<?php 
include 'db.php'; 
session_start();
if(!isset($_SESSION['user'])){ header("Location: login.php"); exit(); }
 $u = $_SESSION['user']; 

// --- منطق قبول الإيداع ---
if (isset($_GET['approve_deposit'])) {
    $id = intval($_GET['approve_deposit']);
    
    // جلب تفاصيل الطلب للتأكد من الحالة والمبلغ
    $check = $conn->query("SELECT * FROM deposits WHERE id=$id AND status='pending'");
    if($check->num_rows > 0){
        $dep = $check->fetch_assoc();
        $uid = $dep['user_id'];
        $amt = $dep['amount'];
        
        // إضافة المبلغ لرصيد المستخدم
        $conn->query("UPDATE users SET balance=balance+$amt WHERE id=$uid");
        
        // تحديث حالة الطلب
        $conn->query("UPDATE deposits SET status='approved' WHERE id=$id");
    }
    header("Location: admin_actions.php"); // إعادة تحديث الصفحة لمنع التكرار
    exit();
}

// --- منطق قبول السحب ---
if (isset($_GET['approve_withdraw'])) {
    $id = intval($_GET['approve_withdraw']);
    $conn->query("UPDATE withdrawals SET status='approved' WHERE id=$id");
    header("Location: admin_actions.php");
    exit();
}

// --- منطق رفض (اختياري) ---
if (isset($_GET['reject'])) {
    $id = intval($_GET['reject']);
    $type = $_GET['type']; // deposit or withdraw
    $table = ($type == 'dep') ? 'deposits' : 'withdrawals';
    $conn->query("UPDATE $table SET status='rejected' WHERE id=$id");
    header("Location: admin_actions.php");
    exit();
}

// جلب البيانات مع الانضمام لجدول المستخدمين لإظهار الأسماء
 $deposits = $conn->query("SELECT d.*, u.username FROM deposits d JOIN users u ON d.user_id = u.id ORDER BY d.id DESC");
 $withdrawals = $conn->query("SELECT w.*, u.username FROM withdrawals w JOIN users u ON w.user_id = u.id ORDER BY w.id DESC");
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Chicken Charge - الطلبات</title>
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #FFD700; 
            --secondary-color: #FF4500;
            --bg-dark: #121212;
            --sidebar-bg: #1a1a1a;
            --card-bg: #1e1e1e;
            --text-muted: #aaa;
        }

        * { box-sizing: border-box; }
        body { font-family: 'Tajawal', sans-serif; background-color: var(--bg-dark); color: white; margin: 0; display: flex; min-height: 100vh; }

        /* Sidebar */
        .sidebar { width: 260px; background: var(--sidebar-bg); border-left: 1px solid #333; display: flex; flex-direction: column; position: fixed; height: 100%; right: 0; top: 0; z-index: 100; }
        .sidebar-header { padding: 30px 20px; text-align: center; border-bottom: 1px solid rgba(255,255,255,0.05); }
        .brand-logo { font-weight: bold; font-size: 1.4rem; background: linear-gradient(45deg, var(--primary-color), var(--secondary-color)); -webkit-background-clip: text; -webkit-text-fill-color: transparent; }
        .nav-links { flex: 1; padding: 20px 0; list-style: none; margin: 0; }
        .nav-links li a { display: flex; align-items: center; padding: 15px 25px; color: var(--text-muted); text-decoration: none; transition: 0.3s; border-right: 3px solid transparent; font-size: 1rem; }
        .nav-links li a:hover, .nav-links li a.active { background: rgba(255, 215, 0, 0.05); color: var(--primary-color); border-right-color: var(--primary-color); }
        .nav-links li a i { margin-left: 15px; width: 20px; text-align: center; }

        /* Main Content */
        .main-content { margin-right: 260px; flex: 1; padding: 30px; width: calc(100% - 260px); }
        .page-title { font-size: 1.8rem; font-weight: bold; margin-bottom: 30px; display: flex; align-items: center; gap: 10px; }
        .page-title i { color: var(--primary-color); }

        .card { background: var(--card-bg); border-radius: 15px; padding: 25px; margin-bottom: 30px; border: 1px solid rgba(255,255,255,0.05); }
        .card-header { margin-bottom: 20px; font-size: 1.2rem; font-weight: bold; border-bottom: 1px solid rgba(255,255,255,0.1); padding-bottom: 10px; display: flex; justify-content: space-between; }

        /* Tables */
        .table-responsive { overflow-x: auto; }
        .custom-table { width: 100%; border-collapse: collapse; min-width: 600px; }
        .custom-table th { text-align: right; padding: 15px; background: rgba(255,255,255,0.05); color: var(--primary-color); border-bottom: 2px solid var(--primary-color); font-weight: bold; }
        .custom-table td { padding: 15px; border-bottom: 1px solid rgba(255,255,255,0.1); color: #ddd; }
        .custom-table tr:hover { background: rgba(255,255,255,0.02); }

        /* Status Badges */
        .badge { padding: 5px 10px; border-radius: 20px; font-size: 0.8rem; font-weight: bold; }
        .badge-pending { background: rgba(255, 165, 0, 0.2); color: orange; }
        .badge-approved { background: rgba(0, 255, 0, 0.2); color: #00ff00; }
        .badge-rejected { background: rgba(255, 0, 0, 0.2); color: #ff4d4d; }

        /* Action Buttons */
        .action-btn { padding: 5px 12px; border-radius: 6px; text-decoration: none; font-size: 0.85rem; transition: 0.2s; display: inline-block; margin-left: 5px; }
        .btn-approve { background: #00ff00; color: black; font-weight: bold; }
        .btn-approve:hover { background: #00cc00; }
        .btn-reject { background: #ff4d4d; color: white; }
        .btn-reject:hover { background: #cc0000; }

        /* Mobile */
        @media (max-width: 768px) {
            .sidebar { width: 70px; }
            .sidebar-header h1, .nav-links span { display: none; }
            .nav-links li a { justify-content: center; padding: 15px 0; }
            .nav-links li a i { margin-left: 0; font-size: 1.2rem; }
            .main-content { margin-right: 70px; width: calc(100% - 70px); padding: 15px; }
        }
    </style>
</head>
<body>

    <!-- القائمة الجانبية -->
    <aside class="sidebar">
        <div class="sidebar-header">
            <div class="brand-logo">Admin Panel</div>
        </div>
        <ul class="nav-links">
            <li><a href="admin.php"><i class="fas fa-tachometer-alt"></i><span>الرئيسية</span></a></li>
            <li><a href="admin_packages.php"><i class="fas fa-boxes"></i><span>إدارة الباقات</span></a></li>
            <li><a href="admin_actions.php" class="active"><i class="fas fa-wallet"></i><span>الطلبات</span></a></li>
            <li><a href="admin_settings.php"><i class="fas fa-cogs"></i><span>الإعدادات</span></a></li>
        </ul>
    </aside>

    <!-- المحتوى -->
    <main class="main-content">
        <h2 class="page-title"><i class="fas fa-list-alt"></i> إدارة العمليات المالية</h2>

        <!-- قسم الإيداعات -->
        <div class="card">
            <div class="card-header">
                <span>طلبات الإيداع</span>
                <i class="fas fa-arrow-down" style="color: #00ff00;"></i>
            </div>
            <div class="table-responsive">
                <table class="custom-table">
                    <thead>
                        <tr>
                            <th>#ID</th>
                            <th>المستخدم</th>
                            <th>المبلغ ($)</th>
                            <th>رقم العملة (TxID)</th>
                            <th>الحالة</th>
                            <th>إجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if($deposits->num_rows > 0): ?>
                            <?php while($d = $deposits->fetch_assoc()): ?>
                                <tr>
                                    <td><?= $d['id'] ?></td>
                                    <td><?= $d['username'] ?></td>
                                    <td style="color: var(--primary-color); font-weight:bold;">$<?= number_format($d['amount'], 2) ?></td>
                                    <td style="direction: ltr; font-family: monospace; font-size: 0.8rem;"><?= $d['txid'] ?></td>
                                    <td>
                                        <?php 
                                        $badgeClass = 'badge-pending';
                                        if($d['status']=='approved') $badgeClass = 'badge-approved';
                                        if($d['status']=='rejected') $badgeClass = 'badge-rejected';
                                        ?>
                                        <span class="badge <?= $badgeClass ?>"><?= ucfirst($d['status']) ?></span>
                                    </td>
                                    <td>
                                        <?php if($d['status']=='pending'): ?>
                                            <a href="?approve_deposit=<?= $d['id'] ?>" class="action-btn btn-approve">
                                                <i class="fas fa-check"></i> قبول
                                            </a>
                                            <a href="?reject=<?= $d['id'] ?>&type=dep" class="action-btn btn-reject" onclick="return confirm('رفض هذا الإيداع؟')">
                                                <i class="fas fa-times"></i>
                                            </a>
                                        <?php else: ?>
                                            <span style="color: #555;">تمت المعالجة</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr><td colspan="6" style="text-align:center;">لا توجد طلبات إيداع</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- قسم السحوبات -->
        <div class="card">
            <div class="card-header">
                <span>طلبات السحب</span>
                <i class="fas fa-arrow-up" style="color: #ff4d4d;"></i>
            </div>
            <div class="table-responsive">
                <table class="custom-table">
                    <thead>
                        <tr>
                            <th>#ID</th>
                            <th>المستخدم</th>
                            <th>المبلغ ($)</th>
                            <th>عنوان المحفظة</th>
                            <th>الحالة</th>
                            <th>إجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if($withdrawals->num_rows > 0): ?>
                            <?php while($w = $withdrawals->fetch_assoc()): ?>
                                <tr>
                                    <td><?= $w['id'] ?></td>
                                    <td><?= $w['username'] ?></td>
                                    <td style="color: var(--secondary-color); font-weight:bold;">$<?= number_format($w['amount'], 2) ?></td>
                                    <td style="direction: ltr; font-family: monospace; font-size: 0.8rem;"><?= $w['address'] ?></td>
                                    <td>
                                        <?php 
                                        $badgeClass = 'badge-pending';
                                        if($w['status']=='approved') $badgeClass = 'badge-approved';
                                        if($w['status']=='rejected') $badgeClass = 'badge-rejected';
                                        ?>
                                        <span class="badge <?= $badgeClass ?>"><?= ucfirst($w['status']) ?></span>
                                    </td>
                                    <td>
                                        <?php if($w['status']=='pending'): ?>
                                            <a href="?approve_withdraw=<?= $w['id'] ?>" class="action-btn btn-approve">
                                                <i class="fas fa-check"></i> صرف
                                            </a>
                                            <a href="?reject=<?= $w['id'] ?>&type=with" class="action-btn btn-reject" onclick="return confirm('رفض هذا السحب؟')">
                                                <i class="fas fa-times"></i>
                                            </a>
                                        <?php else: ?>
                                            <span style="color: #555;">تمت المعالجة</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr><td colspan="6" style="text-align:center;">لا توجد طلبات سحب</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

    </main>

</body>
</html>