<?php 
include 'db.php'; 
session_start();
if(!isset($_SESSION['user'])){ header("Location: login.php"); exit(); }
 $u = $_SESSION['user']; 

 $msg = "";

// معالجة حفظ الإعدادات
if (isset($_POST['save'])) {
    $address = $_POST['deposit_address'];
    $percent = $_POST['referral_percent'];
    $currency = $_POST['currency'];

    // استخدام Prepared Statements للحماية (أو يمكن استخدام الاستعلام العادي مثل طلبك)
    $stmt = $conn->prepare("UPDATE settings SET deposit_address=?, referral_percent=?, currency=? WHERE id=1");
    $stmt->bind_param("sis", $address, $percent, $currency);
    
    if($stmt->execute()){
        $msg = "<div class='success-msg'><i class='fas fa-check-circle'></i> تم حفظ الإعدادات بنجاح</div>";
    }
}

// جلب الإعدادات الحالية
 $settings = $conn->query("SELECT * FROM settings WHERE id=1")->fetch_assoc();
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Chicken Charge - الإعدادات</title>
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #FFD700; 
            --secondary-color: #FF4500;
            --bg-dark: #121212;
            --sidebar-bg: #1a1a1a;
            --card-bg: #1e1e1e;
            --text-muted: #aaa;
        }

        * { box-sizing: border-box; }
        body { font-family: 'Tajawal', sans-serif; background-color: var(--bg-dark); color: white; margin: 0; display: flex; min-height: 100vh; }

        /* Sidebar */
        .sidebar { width: 260px; background: var(--sidebar-bg); border-left: 1px solid #333; display: flex; flex-direction: column; position: fixed; height: 100%; right: 0; top: 0; z-index: 100; }
        .sidebar-header { padding: 30px 20px; text-align: center; border-bottom: 1px solid rgba(255,255,255,0.05); }
        .brand-logo { font-weight: bold; font-size: 1.4rem; background: linear-gradient(45deg, var(--primary-color), var(--secondary-color)); -webkit-background-clip: text; -webkit-text-fill-color: transparent; }
        .nav-links { flex: 1; padding: 20px 0; list-style: none; margin: 0; }
        .nav-links li a { display: flex; align-items: center; padding: 15px 25px; color: var(--text-muted); text-decoration: none; transition: 0.3s; border-right: 3px solid transparent; font-size: 1rem; }
        .nav-links li a:hover, .nav-links li a.active { background: rgba(255, 215, 0, 0.05); color: var(--primary-color); border-right-color: var(--primary-color); }
        .nav-links li a i { margin-left: 15px; width: 20px; text-align: center; }

        /* Main Content */
        .main-content { margin-right: 260px; flex: 1; padding: 30px; width: calc(100% - 260px); }
        .page-title { font-size: 1.8rem; font-weight: bold; margin-bottom: 30px; display: flex; align-items: center; gap: 10px; }
        .page-title i { color: var(--primary-color); }

        /* Settings Card */
        .settings-card { background: var(--card-bg); border-radius: 15px; padding: 30px; border: 1px solid rgba(255,255,255,0.05); max-width: 800px; }
        .section-header { margin-bottom: 25px; font-size: 1.2rem; border-bottom: 1px solid rgba(255,255,255,0.1); padding-bottom: 10px; }

        .form-group { margin-bottom: 25px; }
        .form-label { display: block; margin-bottom: 10px; color: var(--text-muted); font-size: 0.95rem; font-weight: 500; }
        
        .input-wrapper { position: relative; }
        .input-icon { position: absolute; right: 15px; top: 50%; transform: translateY(-50%); color: var(--primary-color); }
        
        .form-input { 
            width: 100%; 
            background: #121212; 
            border: 1px solid #333; 
            padding: 15px 50px 15px 15px; /* مسافة للأيقونة يمين */
            border-radius: 10px; 
            color: white; 
            outline: none; 
            transition: 0.3s; 
            font-family: 'Tajawal', sans-serif;
            font-size: 1rem;
        }
        .form-input:focus { border-color: var(--primary-color); box-shadow: 0 0 10px rgba(255, 215, 0, 0.1); }

        .btn-save { 
            background: linear-gradient(45deg, var(--primary-color), #FFD700); 
            color: black; 
            border: none; 
            padding: 15px 30px; 
            border-radius: 10px; 
            font-weight: bold; 
            cursor: pointer; 
            font-size: 1rem; 
            transition: 0.3s; 
            display: flex; 
            align-items: center; 
            gap: 10px;
        }
        .btn-save:hover { transform: scale(0.98); filter: brightness(1.1); }

        .success-msg {
            background: rgba(0, 255, 0, 0.15);
            color: #00ff00;
            padding: 15px;
            border-radius: 10px;
            margin-bottom: 20px;
            border: 1px solid rgba(0, 255, 0, 0.3);
            display: flex;
            align-items: center;
            gap: 10px;
        }

        /* Mobile */
        @media (max-width: 768px) {
            .sidebar { width: 70px; }
            .sidebar-header h1, .nav-links span { display: none; }
            .nav-links li a { justify-content: center; padding: 15px 0; }
            .nav-links li a i { margin-left: 0; font-size: 1.2rem; }
            .main-content { margin-right: 70px; width: calc(100% - 70px); padding: 15px; }
        }
    </style>
</head>
<body>

    <!-- القائمة الجانبية -->
    <aside class="sidebar">
        <div class="sidebar-header">
            <div class="brand-logo">Admin Panel</div>
        </div>
        <ul class="nav-links">
            <li><a href="admin.php"><i class="fas fa-tachometer-alt"></i><span>الرئيسية</span></a></li>
            <li><a href="admin_packages.php"><i class="fas fa-boxes"></i><span>إدارة الباقات</span></a></li>
            <li><a href="admin_actions.php"><i class="fas fa-wallet"></i><span>الطلبات</span></a></li>
            <li><a href="admin_settings.php" class="active"><i class="fas fa-cogs"></i><span>الإعدادات</span></a></li>
        </ul>
    </aside>

    <!-- المحتوى -->
    <main class="main-content">
        <h2 class="page-title"><i class="fas fa-sliders-h"></i> إعدادات النظام</h2>

        <div class="settings-card">
            <?= $msg ?>

            <form method="post">
                <div class="section-header">الدفع والعملات</div>
                
                <!-- عنوان الإيداع -->
                <div class="form-group">
                    <label class="form-label">عنوان المحفظة للإيداع (USDT TRC20)</label>
                    <div class="input-wrapper">
                        <i class="fas fa-wallet input-icon"></i>
                        <input type="text" name="deposit_address" class="form-input" 
                               value="<?= htmlspecialchars($settings['deposit_address']) ?>" 
                               placeholder="Txxxxxxxxxxxxxxxxxxxxxx">
                    </div>
                </div>

                <!-- العملة -->
                <div class="form-group">
                    <label class="form-label">العملة الافتراضية</label>
                    <div class="input-wrapper">
                        <i class="fas fa-dollar-sign input-icon"></i>
                        <input type="text" name="currency" class="form-input" 
                               value="<?= htmlspecialchars($settings['currency']) ?>" 
                               placeholder="مثال: USD">
                    </div>
                </div>

                <div class="section-header" style="margin-top: 40px;">نظام الإحالة</div>

                <!-- نسبة الإحالة -->
                <div class="form-group">
                    <label class="form-label">نسبة العمولة للمدعو (%)</label>
                    <div class="input-wrapper">
                        <i class="fas fa-percent input-icon"></i>
                        <input type="number" name="referral_percent" class="form-input" 
                               value="<?= $settings['referral_percent'] ?>" 
                               placeholder="مثال: 10">
                    </div>
                </div>

                <div style="margin-top: 30px; text-align: left;">
                    <button type="submit" name="save" class="btn-save">
                        <i class="fas fa-save"></i> حفظ التغييرات
                    </button>
                </div>
            </form>
        </div>

    </main>

</body>
</html>