<?php 
include 'db.php'; 
session_start();
if(!isset($_SESSION['user'])){ header("Location: login.php"); exit(); }
 $u = $_SESSION['user']; 

// جلب إعدادات الموقع (عنوان المحفظة)
 $s = $conn->query("SELECT * FROM settings WHERE id=1")->fetch_assoc();

 $msg = "";

if(isset($_POST['send'])){
    $uid = $u['id'];
    // تنظيف المدخلات
    $a = floatval($_POST['amount']);
    $tx = htmlspecialchars($_POST['txid']);
    
    if($a > 0 && !empty($tx)){
        $conn->query("INSERT INTO deposits(user_id,amount,txid) VALUES($uid,$a,'$tx')");
        $msg = "<div class='success-box'><i class='fas fa-check-circle'></i> تم إرسال طلب الإيداع بنجاح! سيتم المراجعة قريباً.</div>";
    } else {
        $msg = "<div class='error-box'><i class='fas fa-exclamation-circle'></i> يرجى إدخال المبلغ و رقم العملية بشكل صحيح.</div>";
    }
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Chicken Charge - إيداع</title>
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #FFD700; 
            --secondary-color: #FF4500;
            --bg-dark: #121212;
            --card-bg: #1e1e1e;
            --text-muted: #aaa;
        }

        body {
            font-family: 'Tajawal', sans-serif;
            background-color: var(--bg-dark);
            color: white;
            margin: 0;
            padding-bottom: 80px;
        }

        /* الشريط العلوي */
        .top-bar {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 15px 20px;
            background: var(--card-bg);
            border-bottom: 1px solid rgba(255, 215, 0, 0.1);
        }

        .top-bar .brand {
            font-weight: bold;
            font-size: 1.2rem;
            background: linear-gradient(45deg, var(--primary-color), var(--secondary-color));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .back-btn {
            color: white;
            text-decoration: none;
            font-size: 1.2rem;
        }

        /* المحتوى */
        .container {
            padding: 20px;
        }

        .section-title {
            margin-bottom: 20px;
            font-size: 1.2rem;
            border-right: 4px solid var(--secondary-color);
            padding-right: 10px;
        }

        /* كرت عنوان المحفظة */
        .wallet-card {
            background: var(--card-bg);
            border-radius: 20px;
            padding: 25px;
            text-align: center;
            margin-bottom: 25px;
            border: 1px solid rgba(255, 255, 255, 0.05);
        }

        .wallet-label {
            color: var(--text-muted);
            font-size: 0.9rem;
            margin-bottom: 10px;
        }

        .address-box {
            background: #121212;
            border: 1px solid var(--primary-color);
            color: var(--primary-color);
            padding: 15px;
            border-radius: 10px;
            font-family: monospace;
            font-size: 0.9rem;
            word-break: break-all;
            margin-bottom: 15px;
            direction: ltr; /* لكي يظهر الرقم بشكل صحيح */
        }

        .copy-btn-small {
            background: rgba(255, 215, 0, 0.1);
            color: var(--primary-color);
            border: 1px solid var(--primary-color);
            padding: 8px 20px;
            border-radius: 20px;
            cursor: pointer;
            font-family: 'Tajawal', sans-serif;
            transition: 0.2s;
        }

        .copy-btn-small:active {
            background: var(--primary-color);
            color: black;
        }

        /* النموذج */
        .deposit-form {
            background: var(--card-bg);
            border-radius: 20px;
            padding: 20px;
        }

        .input-group {
            margin-bottom: 15px;
        }

        .input-label {
            display: block;
            margin-bottom: 8px;
            color: var(--text-muted);
            font-size: 0.9rem;
        }

        .input-field {
            width: 100%;
            background: #121212;
            border: 1px solid #333;
            padding: 12px 15px;
            border-radius: 12px;
            color: white;
            font-family: 'Tajawal', sans-serif;
            box-sizing: border-box;
            outline: none;
            font-size: 1rem;
        }

        .input-field:focus {
            border-color: var(--primary-color);
        }

        .submit-btn {
            width: 100%;
            background: linear-gradient(45deg, var(--primary-color), #FFD700);
            color: #000;
            border: none;
            padding: 14px;
            border-radius: 12px;
            font-family: 'Tajawal', sans-serif;
            font-weight: bold;
            font-size: 1rem;
            cursor: pointer;
            box-shadow: 0 4px 15px rgba(255, 215, 0, 0.3);
            transition: 0.3s;
            margin-top: 10px;
        }

        .submit-btn:active {
            transform: scale(0.98);
        }

        /* رسائل التنبيه */
        .success-box {
            background: rgba(0, 255, 0, 0.1);
            color: #00ff00;
            padding: 10px;
            border-radius: 10px;
            margin-bottom: 20px;
            text-align: center;
            border: 1px solid rgba(0, 255, 0, 0.2);
        }

        .error-box {
            background: rgba(255, 0, 0, 0.1);
            color: #ff4d4d;
            padding: 10px;
            border-radius: 10px;
            margin-bottom: 20px;
            text-align: center;
            border: 1px solid rgba(255, 0, 0, 0.2);
        }

        /* الشريط السفلي */
        .bottom-nav {
            position: fixed;
            bottom: 0;
            width: 100%;
            background: var(--card-bg);
            display: flex;
            justify-content: space-around;
            padding: 10px 0;
            border-top: 1px solid rgba(255, 215, 0, 0.1);
            z-index: 1000;
        }

        .nav-item {
            text-decoration: none;
            color: #888;
            display: flex;
            flex-direction: column;
            align-items: center;
            font-size: 0.7rem;
        }

        .nav-item.active {
            color: var(--primary-color);
        }

        .nav-item i {
            font-size: 1.3rem;
            margin-bottom: 4px;
        }
    </style>
</head>
<body>

    <!-- الشريط العلوي -->
    <div class="top-bar">
        <a href="home.php" class="back-btn"><i class="fas fa-arrow-right"></i></a>
        <div class="brand">شحن الرصيد</div>
        <div style="width: 24px;"></div> <!-- عنصر وهمي للموازنة -->
    </div>

    <div class="container">
        
        <div class="section-title">عنوان المحفظة</div>

        <!-- معلومات المحفظة -->
        <div class="wallet-card">
            <div class="wallet-label">قم بالإيداع إلى العنوان التالي (USDT/TRC20):</div>
            
            <div class="address-box" id="walletAddress">
                <?= $s['deposit_address'] ?>
            </div>
            
            <button class="copy-btn-small" onclick="copyAddress()">
                <i class="fas fa-copy"></i> نسخ العنوان
            </button>
        </div>

        <div class="section-title">تفاصيل التحويل</div>

        <!-- نموذج الإيداع -->
        <div class="deposit-form">
            <?= $msg ?>

            <form method="post">
                <div class="input-group">
                    <label class="input-label">المبلغ (بالدولار)</label>
                    <input type="number" step="0.01" name="amount" class="input-field" placeholder="مثلاً: 50.00" required>
                </div>

                <div class="input-group">
                    <label class="input-label">رقم العملية (TxID / Hash)</label>
                    <input type="text" name="txid" class="input-field" placeholder="لصق الرقم هنا..." required>
                </div>

                <button type="submit" name="send" class="submit-btn">
                    إرسال طلب الإيداع <i class="fas fa-paper-plane" style="margin-right: 5px;"></i>
                </button>
            </form>
        </div>

        <div style="text-align:center; margin-top:15px; color:#666; font-size:0.8rem;">
            * يتم إضافة الرصيد تلقائياً بعد التأكد من العملية
        </div>

    </div>

    

    <!-- سكربت النسخ -->
    <script>
        function copyAddress() {
            var addressText = document.getElementById("walletAddress").innerText;
            navigator.clipboard.writeText(addressText).then(function() {
                var btn = document.querySelector('.copy-btn-small');
                var originalHTML = btn.innerHTML;
                btn.innerHTML = '<i class="fas fa-check"></i> تم النسخ';
                btn.style.background = "#00ff00";
                btn.style.color = "black";
                btn.style.borderColor = "#00ff00";
                setTimeout(function() {
                    btn.innerHTML = originalHTML;
                    btn.style.background = "rgba(255, 215, 0, 0.1)";
                    btn.style.color = "var(--primary-color)";
                    btn.style.borderColor = "var(--primary-color)";
                }, 2000);
            }, function(err) {
                alert('فشل النسخ');
            });
        }
    </script>

</body>
</html>