<?php 
include 'db.php'; 
session_start();
if(!isset($_SESSION['user'])){ header("Location: login.php"); exit(); }
 $u = $_SESSION['user']; 
 $uid = $u['id'];

// جلب سجل الإيداعات
 $deposits = $conn->query("SELECT * FROM deposits WHERE user_id = $uid ORDER BY id DESC");

// جلب سجل السحوبات
 $withdrawals = $conn->query("SELECT * FROM withdrawals WHERE user_id = $uid ORDER BY id DESC");
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Chicken Charge - سجل العمليات</title>
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #FFD700; 
            --secondary-color: #FF4500;
            --bg-dark: #121212;
            --card-bg: #1e1e1e;
            --text-muted: #aaa;
        }

        body {
            font-family: 'Tajawal', sans-serif;
            background-color: var(--bg-dark);
            color: white;
            margin: 0;
            padding-bottom: 80px; /* مساحة للشريط السفلي */
        }

        /* الشريط العلوي */
        .top-bar {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 15px 20px;
            background: var(--card-bg);
            border-bottom: 1px solid rgba(255, 215, 0, 0.1);
        }

        .top-bar .brand {
            font-weight: bold;
            font-size: 1.2rem;
            background: linear-gradient(45deg, var(--primary-color), var(--secondary-color));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .back-btn {
            color: white;
            text-decoration: none;
            font-size: 1.2rem;
        }

        /* المحتوى */
        .container {
            padding: 20px;
        }

        .section-title {
            margin-bottom: 20px;
            font-size: 1.2rem;
            border-right: 4px solid var(--secondary-color);
            padding-right: 10px;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        /* قائمة العمليات */
        .history-list {
            display: flex;
            flex-direction: column;
            gap: 15px;
            margin-bottom: 40px;
        }

        .history-item {
            background: var(--card-bg);
            border-radius: 15px;
            padding: 15px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            border: 1px solid rgba(255,255,255,0.02);
            transition: 0.2s;
        }

        .history-item:active {
            background: #252525;
        }

        /* تفاصيل العملية (اليمين) */
        .h-info {
            display: flex;
            flex-direction: column;
        }

        .h-id {
            font-size: 0.75rem;
            color: #666;
            margin-bottom: 3px;
        }

        .h-type {
            font-size: 1rem;
            font-weight: bold;
            margin-bottom: 3px;
        }

        .h-meta {
            font-size: 0.8rem;
            color: var(--text-muted);
        }

        /* المبلغ والحالة (اليسار) */
        .h-values {
            text-align: left;
        }

        .h-amount {
            font-size: 1.1rem;
            font-weight: bold;
            margin-bottom: 5px;
        }

        .amount-plus { color: #00ff00; }
        .amount-minus { color: var(--secondary-color); }

        /* الشارات (Status Badges) */
        .badge {
            font-size: 0.75rem;
            padding: 3px 8px;
            border-radius: 8px;
            display: inline-block;
        }
        .badge-pending { background: rgba(255, 165, 0, 0.2); color: orange; }
        .badge-approved { background: rgba(0, 255, 0, 0.2); color: #00ff00; }
        .badge-rejected { background: rgba(255, 0, 0, 0.2); color: #ff4d4d; }

        .empty-msg {
            text-align: center;
            color: #555;
            padding: 20px;
            font-size: 0.9rem;
        }

        /* الشريط السفلي */
        .bottom-nav {
            position: fixed;
            bottom: 0;
            width: 100%;
            background: var(--card-bg);
            display: flex;
            justify-content: space-around;
            padding: 10px 0;
            border-top: 1px solid rgba(255, 215, 0, 0.1);
            z-index: 1000;
        }

        .nav-item {
            text-decoration: none;
            color: #888;
            display: flex;
            flex-direction: column;
            align-items: center;
            font-size: 0.7rem;
        }

        /* تفعيل زر الملف لأننا داخل صفحة فرعية */
        .nav-item.active {
            color: var(--primary-color);
        }

        .nav-item i {
            font-size: 1.3rem;
            margin-bottom: 4px;
        }
    </style>
</head>
<body>

    <!-- الشريط العلوي -->
    <div class="top-bar">
        <a href="profile.php" class="back-btn"><i class="fas fa-arrow-right"></i></a>
        <div class="brand">سجل العمليات</div>
        <div style="width: 24px;"></div> <!-- عنصر وهمي للموازنة -->
    </div>

    <div class="container">

        <!-- قسم الإيداعات -->
        <div class="section-title">
            <i class="fas fa-arrow-down" style="color: #00ff00;"></i> سجل الإيداعات
        </div>
        <div class="history-list">
            <?php if($deposits->num_rows > 0): ?>
                <?php while($d = $deposits->fetch_assoc()): ?>
                    <div class="history-item">
                        <div class="h-info">
                            <div class="h-id">TXID: <?= substr($d['txid'], 0, 8) ?>...</div>
                            <div class="h-type">إيداع</div>
                            <div class="h-meta"><?= date('Y-m-d', strtotime($d['created_at'] ?? 'now')) ?></div>
                        </div>
                        <div class="h-values">
                            <div class="h-amount amount-plus">+$<?= number_format($d['amount'], 2) ?></div>
                            <?php 
                            $badge = 'badge-pending';
                            $statusText = 'قيد المراجعة';
                            if($d['status']=='approved'){ $badge = 'badge-approved'; $statusText = 'مكتمل'; }
                            if($d['status']=='rejected'){ $badge = 'badge-rejected'; $statusText = 'مرفوض'; }
                            ?>
                            <span class="badge <?= $badge ?>"><?= $statusText ?></span>
                        </div>
                    </div>
                <?php endwhile; ?>
            <?php else: ?>
                <div class="empty-msg">لا توجد سجلات إيداع</div>
            <?php endif; ?>
        </div>

        <!-- قسم السحوبات -->
        <div class="section-title">
            <i class="fas fa-arrow-up" style="color: var(--secondary-color);"></i> سجل السحوبات
        </div>
        <div class="history-list">
            <?php if($withdrawals->num_rows > 0): ?>
                <?php while($w = $withdrawals->fetch_assoc()): ?>
                    <div class="history-item">
                        <div class="h-info">
                            <div class="h-id">ID: #<?= $w['id'] ?></div>
                            <div class="h-type">سحب</div>
                            <div class="h-meta">محفظة: <?= substr($w['address'], 0, 6) ?>...</div>
                        </div>
                        <div class="h-values">
                            <div class="h-amount amount-minus">-$<?= number_format($w['amount'], 2) ?></div>
                            <?php 
                            $badge = 'badge-pending';
                            $statusText = 'قيد المراجعة';
                            if($w['status']=='approved'){ $badge = 'badge-approved'; $statusText = 'مكتمل'; }
                            if($w['status']=='rejected'){ $badge = 'badge-rejected'; $statusText = 'مرفوض'; }
                            ?>
                            <span class="badge <?= $badge ?>"><?= $statusText ?></span>
                        </div>
                    </div>
                <?php endwhile; ?>
            <?php else: ?>
                <div class="empty-msg">لا توجد سجلات سحب</div>
            <?php endif; ?>
        </div>

    </div>

    <!-- الشريط السفلي -->
    <nav class="bottom-nav">
        <a href="home.php" class="nav-item">
            <i class="fas fa-home"></i>
            <span>البيت</span>
        </a>
        <a href="tasks.php" class="nav-item">
            <i class="fas fa-tasks"></i>
            <span>المهام</span>
        </a>
        <a href="referral.php" class="nav-item">
            <i class="fas fa-users"></i>
            <span>الأصدقاء</span>
        </a>
        <a href="packages.php" class="nav-item">
            <i class="fas fa-box-open"></i>
            <span>الباقات</span>
        </a>
        <!-- تفعيل زر الملف لأننا في صفحة تابعة له -->
        <a href="profile.php" class="nav-item active">
            <i class="fas fa-user-circle"></i>
            <span>ملفي</span>
        </a>
    </nav>

</body>
</html>