<?php 
include 'db.php'; 
session_start();
if(!isset($_SESSION['user'])){ header("Location: login.php"); exit(); }
 $u = $_SESSION['user']; 
 $uid = $u['id'];

// جلب بيانات الباقة النشطة (تمت إضافة p.image للاستعلام)
 $q = $conn->query("SELECT p.name, p.daily_profit, u.completed, u.last_claim, p.image 
                   FROM user_packages u 
                   JOIN packages p ON p.id = u.package_id 
                   WHERE u.user_id = $uid");
                   
 $r = $q->fetch_assoc();

 $message = "";
 $now = time();
 $can_claim = true;
 $next_claim_time = 0;
 $seconds_left = 0;

// إذا لم يكن هناك باقة
if (!$r) {
    $message = "لم تقم بشراء أي باقة بعد.";
} else {
    // التحقق من مرور 24 ساعة (86400 ثانية)
    if (!empty($r['last_claim'])) {
        $next_claim_time = $r['last_claim'] + 86400; // وقت الحصة القادمة
        if ($now < $next_claim_time) {
            $can_claim = false;
            $seconds_left = $next_claim_time - $now;
        }
    }
}

// معالجة الضغط على زر "إكمال"
if(isset($_POST['done']) && $r && $can_claim){
    // تحديث الرصيد (يتم إضافة الأرباح لرصيد السحب withdraw_balance كما طلبت سابقاً)
    // ملاحظة: تأكد أنك عدلت هذا السطر في نسختك ليزيد withdraw_balance وليس balance
    $conn->query("UPDATE users SET withdraw_balance=withdraw_balance+{$r['daily_profit']} WHERE id=$uid");
    
    // تحديث عدد المهام ووقت آخر عملية سحب
    $conn->query("UPDATE user_packages SET completed=completed+1, last_claim=$now WHERE user_id=$uid");
    
    // إعادة توجيه لتحديث الصفحة وبدء العداد
    header("Location: tasks.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Chicken Charge - المهام</title>
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #FFD700; 
            --secondary-color: #FF4500;
            --bg-dark: #121212;
            --card-bg: #1e1e1e;
            --text-muted: #aaa;
        }

        body {
            font-family: 'Tajawal', sans-serif;
            background-color: var(--bg-dark);
            color: white;
            margin: 0;
            padding-bottom: 80px;
        }

        /* الشريط العلوي */
        .top-bar {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 15px 20px;
            background: var(--card-bg);
            border-bottom: 1px solid rgba(255, 215, 0, 0.1);
        }

        .top-bar .brand {
            font-weight: bold;
            font-size: 1.2rem;
            background: linear-gradient(45deg, var(--primary-color), var(--secondary-color));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        /* المحتوى الرئيسي */
        .container {
            padding: 20px;
        }

        .section-title {
            margin-bottom: 20px;
            font-size: 1.2rem;
            border-right: 4px solid var(--secondary-color);
            padding-right: 10px;
        }

        /* كرت المهمة */
        .task-card {
            background: var(--card-bg);
            border-radius: 20px;
            padding: 25px;
            text-align: center;
            border: 1px solid rgba(255, 255, 255, 0.05);
            margin-bottom: 20px;
            position: relative;
            overflow: hidden;
        }

        /* صورة المهمة (من لوحة التحكم) */
        .task-image {
            width: 90px;
            height: 90px;
            border-radius: 50%; /* صورة دائرية */
            object-fit: cover;
            border: 3px solid var(--primary-color);
            margin: 0 auto 15px;
            display: block;
            background: #333; /* لون الخلفية عند تحميل الصورة */
        }

        .task-icon {
            /* تم استبدالها بصورة، احتفظ بالكود احتياطاً */
            font-size: 3rem;
            color: var(--primary-color);
            margin-bottom: 15px;
        }

        .task-info h3 {
            margin: 0 0 5px;
            font-size: 1.3rem;
        }

        .task-info p {
            color: var(--text-muted);
            margin: 5px 0 20px;
            font-size: 0.9rem;
        }

        .profit-badge {
            display: inline-block;
            background: rgba(0, 255, 0, 0.15);
            color: #00ff00;
            padding: 5px 15px;
            border-radius: 15px;
            font-weight: bold;
            font-size: 0.9rem;
            margin-bottom: 20px;
        }

        /* زر الإكمال */
        .claim-btn {
            background: linear-gradient(45deg, var(--primary-color), #FFD700);
            color: #000;
            border: none;
            padding: 15px 40px;
            border-radius: 30px;
            font-size: 1.1rem;
            font-weight: bold;
            font-family: 'Tajawal', sans-serif;
            cursor: pointer;
            box-shadow: 0 5px 15px rgba(255, 215, 0, 0.4);
            transition: transform 0.2s, box-shadow 0.2s;
            width: 100%;
        }

        .claim-btn:active {
            transform: scale(0.95);
        }

        .claim-btn:disabled {
            background: #333;
            color: #666;
            cursor: not-allowed;
            box-shadow: none;
        }

        /* عداد التنازلي */
        .countdown-box {
            display: none;
            background: #2a2a2a;
            padding: 15px;
            border-radius: 10px;
            margin-top: 15px;
            border: 1px solid var(--secondary-color);
        }

        .countdown-label {
            font-size: 0.8rem;
            color: var(--text-muted);
            margin-bottom: 5px;
        }

        .timer-digits {
            font-family: monospace;
            font-size: 1.8rem;
            font-weight: bold;
            color: var(--secondary-color);
            letter-spacing: 2px;
        }

        /* الشريط السفلي */
        .bottom-nav {
            position: fixed;
            bottom: 0;
            width: 100%;
            background: var(--card-bg);
            display: flex;
            justify-content: space-around;
            padding: 10px 0;
            border-top: 1px solid rgba(255, 215, 0, 0.1);
            z-index: 1000;
        }

        .nav-item {
            text-decoration: none;
            color: #888;
            display: flex;
            flex-direction: column;
            align-items: center;
            font-size: 0.7rem;
        }

        .nav-item.active {
            color: var(--primary-color);
        }

        .nav-item i {
            font-size: 1.3rem;
            margin-bottom: 4px;
        }
    </style>
</head>
<body>

    <!-- الشريط العلوي -->
    <div class="top-bar">
        <div class="brand">Chicken Charge</div>
        <div style="font-size: 0.8rem; color: #888;">
            ID: <?= $uid ?>
        </div>
    </div>

    <div class="container">
        <div class="section-title">المهام اليومية</div>

        <?php if($r): ?>
        <div class="task-card">
            <!-- صورة الباقة من قاعدة البيانات -->
            <?php 
                $taskImg = (!empty($r['image'])) ? $r['image'] : 'https://via.placeholder.com/90?text=PKG';
            ?>
            <img src="<?= $taskImg ?>" class="task-image" alt="Package Image">
            
            <div class="task-info">
                <h3><?= $r['name'] ?></h3>
                <p>مجموع المهام المكتملة: <?= $r['completed'] ?></p>
                <div class="profit-badge">
                    +$<?= number_format($r['daily_profit'], 2) ?> ربح يومي
                </div>
            </div>

            <?php if($can_claim): ?>
                <form method="post">
                    <button type="submit" name="done" class="claim-btn">
                        إكمال المهمة <i class="fas fa-check"></i>
                    </button>
                </form>
            <?php else: ?>
                <!-- العداد يظهر فقط إذا لم يحن الوقت -->
                <div class="countdown-box" style="display: block;">
                    <div class="countdown-label">الوقت المتبقي للمهمة القادمة</div>
                    <div class="timer-digits" id="timer">--:--:--</div>
                </div>
            <?php endif; ?>

        </div>
        <?php else: ?>
            <div style="text-align:center; color:#666; padding:20px;">
                <?= $message ?>
                <br><br>
                <a href="packages.php" style="color:var(--primary-color);">شراء باقة</a>
            </div>
        <?php endif; ?>
    </div>

    <!-- الشريط السفلي -->
    <nav class="bottom-nav">
        <a href="home.php" class="nav-item">
            <i class="fas fa-home"></i>
            <span>البيت</span>
        </a>
        <!-- تفعيل زر المهام -->
        <a href="tasks.php" class="nav-item active">
            <i class="fas fa-tasks"></i>
            <span>المهام</span>
        </a>
        <a href="referral.php" class="nav-item">
            <i class="fas fa-users"></i>
            <span>الأصدقاء</span>
        </a>
        <a href="packages.php" class="nav-item">
            <i class="fas fa-box-open"></i>
            <span>الباقات</span>
        </a>
        <a href="profile.php" class="nav-item">
            <i class="fas fa-user-circle"></i>
            <span>ملفي</span>
        </a>
    </nav>

    <!-- سكربت العداد -->
    <?php if(!$can_claim && isset($seconds_left)): ?>
    <script>
        // تحميل الوقت المتبقي من PHP
        var secondsLeft = <?= $seconds_left ?>;
        
        function updateTimer() {
            var hours = Math.floor(secondsLeft / 3600);
            var minutes = Math.floor((secondsLeft % 3600) / 60);
            var seconds = secondsLeft % 60;

            // تنسيق الوقت بإضافة أصفار (مثلاً 09 بدلاً من 9)
            hours = hours < 10 ? "0" + hours : hours;
            minutes = minutes < 10 ? "0" + minutes : minutes;
            seconds = seconds < 10 ? "0" + seconds : seconds;

            document.getElementById("timer").innerHTML = hours + ":" + minutes + ":" + seconds;

            if (secondsLeft > 0) {
                secondsLeft--;
            } else {
                // عند انتهاء الوقت، قم بتحديث الصفحة لإظهار الزر
                location.reload();
            }
        }

        // تشغيل العداد كل ثانية
        setInterval(updateTimer, 1000);
        // تشغيله فوراً لتجنب التأخير
        updateTimer();
    </script>
    <?php endif; ?>

</body>
</html>