<?php 
include 'db.php'; 
session_start();
if(!isset($_SESSION['user'])){ header("Location: login.php"); exit(); }
 $u = $_SESSION['user']; 

// منطق إضافة الباقة
if (isset($_POST['add'])) {
    $name = $_POST['name'];
    $price = $_POST['price'];
    $profit = $_POST['daily_profit'];
    $days = $_POST['days'];
    $img = $_POST['image_url']; // إضافة حقل الصورة

    $stmt = $conn->prepare("INSERT INTO packages (name, price, daily_profit, days, image) VALUES (?, ?, ?, ?, ?)");
    $stmt->bind_param("sddis", $name, $price, $profit, $days, $img);
    $stmt->execute();
    echo "<script>alert('تم إضافة الباقة بنجاح'); window.location='admin_packages.php';</script>";
}

// منطق حذف الباقة
if(isset($_GET['delete'])){
    $id = intval($_GET['delete']);
    $conn->query("DELETE FROM packages WHERE id=$id");
    echo "<script>window.location='admin_packages.php';</script>";
}

 $packages = $conn->query("SELECT * FROM packages ORDER BY id DESC");
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Chicken Charge - إدارة الباقات</title>
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #FFD700; 
            --secondary-color: #FF4500;
            --bg-dark: #121212;
            --sidebar-bg: #1a1a1a;
            --card-bg: #1e1e1e;
            --text-muted: #aaa;
        }

        * { box-sizing: border-box; }
        body { font-family: 'Tajawal', sans-serif; background-color: var(--bg-dark); color: white; margin: 0; display: flex; min-height: 100vh; }

        /* Sidebar (نفس السابق) */
        .sidebar { width: 260px; background: var(--sidebar-bg); border-left: 1px solid #333; display: flex; flex-direction: column; position: fixed; height: 100%; right: 0; top: 0; z-index: 100; }
        .sidebar-header { padding: 30px 20px; text-align: center; border-bottom: 1px solid rgba(255,255,255,0.05); }
        .brand-logo { font-weight: bold; font-size: 1.4rem; background: linear-gradient(45deg, var(--primary-color), var(--secondary-color)); -webkit-background-clip: text; -webkit-text-fill-color: transparent; }
        .nav-links { flex: 1; padding: 20px 0; list-style: none; margin: 0; }
        .nav-links li a { display: flex; align-items: center; padding: 15px 25px; color: var(--text-muted); text-decoration: none; transition: 0.3s; border-right: 3px solid transparent; font-size: 1rem; }
        .nav-links li a:hover, .nav-links li a.active { background: rgba(255, 215, 0, 0.05); color: var(--primary-color); border-right-color: var(--primary-color); }
        .nav-links li a i { margin-left: 15px; width: 20px; text-align: center; }

        /* Main Content */
        .main-content { margin-right: 260px; flex: 1; padding: 30px; width: calc(100% - 260px); }
        .page-title { font-size: 1.8rem; font-weight: bold; margin-bottom: 30px; display: flex; align-items: center; gap: 10px; }
        .page-title i { color: var(--primary-color); }

        /* Form Card */
        .card { background: var(--card-bg); border-radius: 15px; padding: 25px; margin-bottom: 30px; border: 1px solid rgba(255,255,255,0.05); }
        .card-header { margin-bottom: 20px; font-size: 1.2rem; font-weight: bold; border-bottom: 1px solid rgba(255,255,255,0.1); padding-bottom: 10px; }
        
        .form-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 20px; }
        .form-group { margin-bottom: 15px; }
        .form-group label { display: block; margin-bottom: 8px; color: var(--text-muted); font-size: 0.9rem; }
        .form-input { width: 100%; background: #121212; border: 1px solid #333; padding: 12px; border-radius: 8px; color: white; outline: none; transition: 0.3s; }
        .form-input:focus { border-color: var(--primary-color); }
        
        .btn { padding: 12px 25px; border: none; border-radius: 8px; cursor: pointer; font-family: inherit; font-weight: bold; transition: 0.3s; }
        .btn-primary { background: linear-gradient(45deg, var(--primary-color), #FFD700); color: black; width: 100%; }
        .btn-primary:hover { transform: scale(0.98); }

        /* Table Styling */
        .table-responsive { overflow-x: auto; }
        .custom-table { width: 100%; border-collapse: collapse; min-width: 600px; }
        .custom-table th { text-align: right; padding: 15px; background: rgba(255,255,255,0.05); color: var(--primary-color); border-bottom: 2px solid var(--primary-color); font-weight: bold; }
        .custom-table td { padding: 15px; border-bottom: 1px solid rgba(255,255,255,0.1); color: #ddd; }
        .custom-table tr:hover { background: rgba(255,255,255,0.02); }
        
        .pkg-img-thumb { width: 40px; height: 40px; border-radius: 5px; object-fit: cover; border: 1px solid #444; }
        .btn-delete { background: rgba(255, 69, 0, 0.2); color: var(--secondary-color); padding: 5px 10px; border-radius: 5px; text-decoration: none; font-size: 0.8rem; }
        .btn-delete:hover { background: var(--secondary-color); color: white; }

        /* Mobile */
        @media (max-width: 768px) {
            .sidebar { width: 70px; }
            .sidebar-header h1, .nav-links span { display: none; }
            .nav-links li a { justify-content: center; padding: 15px 0; }
            .nav-links li a i { margin-left: 0; font-size: 1.2rem; }
            .main-content { margin-right: 70px; width: calc(100% - 70px); padding: 15px; }
            .form-grid { grid-template-columns: 1fr; }
        }
    </style>
</head>
<body>

    <!-- القائمة الجانبية -->
    <aside class="sidebar">
        <div class="sidebar-header">
            <div class="brand-logo">Admin Panel</div>
        </div>
        <ul class="nav-links">
            <li><a href="admin.php"><i class="fas fa-tachometer-alt"></i><span>الرئيسية</span></a></li>
            <li><a href="admin_packages.php" class="active"><i class="fas fa-boxes"></i><span>إدارة الباقات</span></a></li>
            <li><a href="admin_actions.php"><i class="fas fa-wallet"></i><span>الطلبات</span></a></li>
            <li><a href="admin_settings.php"><i class="fas fa-cogs"></i><span>الإعدادات</span></a></li>
        </ul>
    </aside>

    <!-- المحتوى -->
    <main class="main-content">
        <h2 class="page-title"><i class="fas fa-box-open"></i> إدارة الباقات</h2>

        <!-- نموذج إضافة باقة -->
        <div class="card">
            <div class="card-header">إضافة باقة جديدة</div>
            <form method="post">
                <div class="form-grid">
                    <div class="form-group">
                        <label>اسم الباقة</label>
                        <input type="text" name="name" class="form-input" placeholder="مثلاً: الباقة الذهبية" required>
                    </div>
                    <div class="form-group">
                        <label>السعر ($)</label>
                        <input type="number" step="0.01" name="price" class="form-input" placeholder="0.00" required>
                    </div>
                    <div class="form-group">
                        <label>الربح اليومي ($)</label>
                        <input type="number" step="0.01" name="daily_profit" class="form-input" placeholder="0.00" required>
                    </div>
                    <div class="form-group">
                        <label>مدة الباقة (أيام)</label>
                        <input type="number" name="days" class="form-input" placeholder="30" required>
                    </div>
                    <div class="form-group" style="grid-column: 1 / -1;">
                        <label>رابط الصورة (اختياري)</label>
                        <input type="text" name="image_url" class="form-input" placeholder="https://example.com/image.jpg">
                    </div>
                </div>
                <button type="submit" name="add" class="btn btn-primary">إضافة الباقة</button>
            </form>
        </div>

        <!-- جدول الباقات -->
        <div class="card">
            <div class="card-header">قائمة الباقات الحالية</div>
            <div class="table-responsive">
                <table class="custom-table">
                    <thead>
                        <tr>
                            <th width="5%">#ID</th>
                            <th width="10%">صورة</th>
                            <th>الاسم</th>
                            <th>السعر</th>
                            <th>الربح اليومي</th>
                            <th>الأيام</th>
                            <th width="10%">إجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if($packages->num_rows > 0): ?>
                            <?php while($row = $packages->fetch_assoc()): ?>
                                <tr>
                                    <td><?= $row['id'] ?></td>
                                    <td>
                                        <?php 
                                        $imgSrc = !empty($row['image']) ? $row['image'] : 'https://via.placeholder.com/40?text=No+Img'; 
                                        ?>
                                        <img src="<?= $imgSrc ?>" class="pkg-img-thumb" alt="pkg">
                                    </td>
                                    <td><?= $row['name'] ?></td>
                                    <td style="color: var(--primary-color); font-weight: bold;">$<?= number_format($row['price'], 2) ?></td>
                                    <td>$<?= number_format($row['daily_profit'], 2) ?></td>
                                    <td><?= $row['days'] ?> يوم</td>
                                    <td>
                                        <a href="?delete=<?= $row['id'] ?>" class="btn-delete" onclick="return confirm('هل أنت متأكد من الحذف؟')">
                                            <i class="fas fa-trash"></i> حذف
                                        </a>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr><td colspan="7" style="text-align:center; padding: 20px;">لا توجد باقات مضافة بعد</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

    </main>

</body>
</html>