<?php 
include 'db.php'; 
session_start();
if(!isset($_SESSION['user'])){ header("Location: login.php"); exit(); }
 $u = $_SESSION['user']; 
 // ضع هذا بعد تسجيل الدخول وتحديث الجلسة
 $today = date('Y-m-d');

// التحقق من أن المستخدم لم يسحب جائزته اليوم
if($u['last_daily_spin_date'] != $today){
    $conn->query("UPDATE users SET spins=spins+1, last_daily_spin_date='$today' WHERE id=".$u['id']);
    
    // تحديث الجلسة لتظهر الفرصة فوراً
    $_SESSION['user']['spins']++;
    $_SESSION['user']['last_daily_spin_date'] = $today;
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Chicken Charge - الرئيسية</title>
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #FFD700; 
            --secondary-color: #FF4500;
            --bg-dark: #121212;
            --card-bg: #1e1e1e;
        }

        body {
            font-family: 'Tajawal', sans-serif;
            background-color: var(--bg-dark);
            color: white;
            margin: 0;
            padding-bottom: 80px; /* مساحة للشريط السفلي */
        }

        /* الشريط العلوي */
        .top-bar {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 15px 20px;
            background: var(--card-bg);
            border-bottom: 1px solid rgba(255, 215, 0, 0.1);
        }

        .top-bar .brand {
            font-weight: bold;
            font-size: 1.2rem;
            background: linear-gradient(45deg, var(--primary-color), var(--secondary-color));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .logout-btn {
            color: #ff4d4d;
            text-decoration: none;
            font-size: 1.2rem;
        }

        /* السلايدر (صورة تعبيرية) */
        .slider-container {
            margin: 15px;
            height: 160px;
            border-radius: 20px;
            background: linear-gradient(rgba(0,0,0,0.3), rgba(0,0,0,0.3)), url('https://f.top4top.io/p_3645hgf8u0.png');
            background-size: cover;
            background-position: center;
            display: flex;
            align-items: center;
            justify-content: center;
            border: 1px solid rgba(255, 215, 0, 0.2);
        }

        .slider-text {
            text-align: center;
            font-weight: bold;
            text-shadow: 2px 2px 10px rgba(0,0,0,0.8);
        }

        /* كروت الرصيد */
        .balance-section {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 15px;
            padding: 0 15px;
            margin-bottom: 25px;
        }

        .balance-card {
            background: var(--card-bg);
            padding: 20px 10px;
            border-radius: 20px;
            text-align: center;
            border-bottom: 3px solid var(--primary-color);
        }

        .balance-card span {
            display: block;
            color: #888;
            font-size: 0.8rem;
            margin-bottom: 5px;
        }

        .balance-card h3 {
            margin: 0;
            font-size: 1.2rem;
            color: var(--primary-color);
        }

        /* أيقونات الخدمات (4 أفقي) */
        .services-grid {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 10px;
            padding: 0 15px;
            margin-bottom: 30px;
        }

        .service-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            text-decoration: none;
            color: white;
        }

        .icon-box {
            width: 55px;
            height: 55px;
            background: #2a2a2a;
            border-radius: 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 8px;
            font-size: 1.4rem;
            color: var(--primary-color);
            transition: 0.3s;
        }

        .service-item:active .icon-box {
            transform: scale(0.9);
            background: var(--primary-color);
            color: black;
        }

        .service-item span {
            font-size: 0.75rem;
        }

        /* الشريط السفلي */
        .bottom-nav {
            position: fixed;
            bottom: 0;
            width: 100%;
            background: var(--card-bg);
            display: flex;
            justify-content: space-around;
            padding: 10px 0;
            border-top: 1px solid rgba(255, 215, 0, 0.1);
            z-index: 1000;
        }

        .nav-item {
            text-decoration: none;
            color: #888;
            display: flex;
            flex-direction: column;
            align-items: center;
            font-size: 0.7rem;
        }

        .nav-item.active {
            color: var(--primary-color);
        }

        .nav-item i {
            font-size: 1.3rem;
            margin-bottom: 4px;
        }
        
        
        /* --- ستايل قسم الباقات المتاحة --- */

/* حاوية التمرير الأفقي */
.packages-scroll-container {
    padding: 0 15px 20px 15px; /* يسار، يمين، أسفل، علوي */
    margin-bottom: 20px;
    display: flex;
    overflow-x: auto; /* تفعيل السكرول الأفقي */
    gap: 15px; /* المسافة بين الباقات */
    scroll-behavior: smooth;
    /* إخفاء شريط السكرول لمظهر أنظف */
    -ms-overflow-style: none;  /* IE and Edge */
    scrollbar-width: none;  /* Firefox */
}

.packages-scroll-container::-webkit-scrollbar {
    display: none;
}

/* تصميم كرت الباقة المصغر */
.pkg-card {
    min-width: 260px; /* عرض ثابت لكل كرت */
    background: var(--card-bg);
    border-radius: 15px;
    padding: 15px;
    display: flex;
    align-items: center;
    border: 1px solid rgba(255,255,255,0.05);
    position: relative;
    transition: 0.3s;
}

.pkg-card:active {
    transform: scale(0.98);
}

/* صورة الباقة */
.pkg-img-sm {
    width: 60px;
    height: 60px;
    border-radius: 12px;
    object-fit: cover;
    margin-left: 15px;
    border: 1px solid #333;
}

/* تفاصيل الباقة */
.pkg-info-sm {
    flex: 1;
}

.pkg-title-sm {
    font-size: 1rem;
    font-weight: bold;
    margin-bottom: 4px;
    color: white;
}

.pkg-profit-sm {
    font-size: 0.75rem;
    color: var(--text-muted);
    margin-bottom: 8px;
}

.pkg-price-sm {
    font-size: 0.95rem;
    color: var(--primary-color);
    font-weight: bold;
    margin-bottom: 8px;
    display: block;
}

/* زر الشراء */
.pkg-buy-btn-sm {
    background: var(--secondary-color);
    color: white;
    border: none;
    padding: 6px 15px;
    border-radius: 8px;
    font-size: 0.8rem;
    cursor: pointer;
    font-family: 'Tajawal', sans-serif;
    width: 100%;
    box-sizing: border-box; /* مهم لضبط العرض */
}

.pkg-buy-btn-sm:disabled {
    background: #444;
    color: #888;
    cursor: not-allowed;
}
    </style>
</head>
<body>

    <div class="top-bar">
        <div class="brand">Chicken Charge</div>
        <a href="logout.php" class="logout-btn"><i class="fas fa-sign-out-alt"></i></a>
    </div>

    <div class="slider-container">
        <div class="slider-text">
            <h2>مرحباً، <?= $u['username'] ?></h2>
            <p>جاهز لشحن طاقتك اليوم؟</p>
        </div>
    </div>

    <div class="balance-section">
        <!-- البطاقة الأولى: رصيد الإيداع (المال الذي أضفته للشراء) -->
        <div class="balance-card">
            <span>رصيد الإيداع</span>
            <h3>$<?= number_format($u['balance'], 2) ?></h3>
        </div>
        
        <!-- البطاقة الثانية: الرصيد الحالي (أرباح المهام) -->
        <div class="balance-card" style="border-bottom-color: var(--secondary-color);">
            <span>الرصيد الحالي</span>
            <h3>$<?= number_format($u['withdraw_balance'], 2) ?></h3>
        </div>
    </div>

    <div class="services-grid">
        <a href="deposit.php" class="service-item">
            <div class="icon-box"><i class="fas fa-wallet"></i></div>
            <span>إيداع</span>
        </a>
        <a href="withdraw.php" class="service-item">
            <div class="icon-box"><i class="fas fa-money-bill-transfer"></i></div>
            <span>سحب</span>
        </a>
        <a href="tasks.php" class="service-item">
            <div class="icon-box"><i class="fas fa-list-check"></i></div>
            <span>المهام</span>
        </a>
        <a href="referral.php" class="service-item">
            <div class="icon-box"><i class="fas fa-user-plus"></i></div>
            <span>دعوة</span>
        </a>
    </div>

<!-- زر البانر المستطيل (خلفية ضبابية) -->
<a href="spin.php" class="blur-spin-banner">
    <!-- طبقة الخلفية (الصورة مع الضباب) -->
    <div class="blur-bg"></div>

    <!-- المحتوى (النص فوق الضباب) -->
    <div class="banner-content">
        <h3> SPIN</h3>
        <span>اضغط وحصل فرصة مجانية، $199</span>
    </div>
</a>

<!-- الستايل -->
<style>
    .blur-spin-banner {
        position: relative;
        width: 90%; /* عرض متجاوب */
        max-width: 500px;
        height: 130px; /* ارتفاع البانر */
        display: block;
        margin: 20px auto;
        border-radius: 20px;
        overflow: hidden;
        text-decoration: none;
        box-shadow: 0 5px 15px rgba(0,0,0,0.3);
        transition: 0.3s;
    }

    /* الخلفية الصورية */
    .blur-bg {
        position: absolute;
        top: 0; left: 0; right: 0; bottom: 0;
        /* الصورة المطلوبة */
        background-image: url('https://j.top4top.io/p_3645p9wjd0.png');
        background-size: cover;
        background-position: center;
        
        /* تأثير الضبابية والإعتام */
        filter: blur(4px) brightness(0.6);
        /* تكبير بسيط لمنع ظهور الحواف البيضاء عند الضباب */
        transform: scale(1.1); 
        transition: 0.5s;
    }

    /* المحتوى في الأعلى */
    .banner-content {
        position: relative;
        z-index: 2; /* ليكون فوق الخلفية */
        height: 100%;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        color: white;
        text-align: center;
        border: 1px solid rgba(255,255,255,0.2); /* إطار خفيف */
        border-radius: 20px;
    }

    .banner-content h3 {
        margin: 0;
        font-size: 1.4rem;
        text-shadow: 0 2px 4px black;
        font-family: 'Tajawal', sans-serif;
    }

    .banner-content span {
        margin-top: 5px;
        font-size: 1rem;
        opacity: 0.9;
        text-shadow: 0 1px 2px black;
        font-family: 'Tajawal', sans-serif;
    }

    /* عند تمرير الماوس (أو اللمس): إلغاء الضباب وإظهار الصورة */
    .blur-spin-banner:hover .blur-bg {
        filter: blur(0) brightness(1);
    }
    .blur-spin-banner:hover {
        transform: scale(1.02);
    }
</style>

    <!-- قسم الباقات المتاحة -->
    <div style="padding: 0 15px;">
        <div style="display: flex; justify-content: space-between; align-items: flex-end; margin-bottom: 15px;">
            <h3 style="margin: 0; font-size: 1.1rem; color: white;">باقات مميزة</h3>
            <a href="packages.php" style="color: var(--text-muted); text-decoration: none; font-size: 0.9rem;">عرض الكل</a>
        </div>
    </div>

    <div class="packages-scroll-container">
        <?php 
        // جلب الباقات
        $pkgs = $conn->query("SELECT * FROM packages");
        if($pkgs->num_rows > 0):
            while($pkg = $pkgs->fetch_assoc()):
                // التحقق من الرصيد (اختياري لتغيير لون الزر)
                $can_buy = ($u['balance'] >= $pkg['price']);
                // الصورة الافتراضية
                $pkgImg = !empty($pkg['image']) ? $pkg['image'] : 'https://via.placeholder.com/60?text=PKG';
        ?>
        
        <!-- كرت الباقة -->
        <div class="pkg-card">
            <img src="<?= $pkgImg ?>" alt="pkg" class="pkg-img-sm">
            <div class="pkg-info-sm">
                <div class="pkg-title-sm"><?= $pkg['name'] ?></div>
                <div class="pkg-profit-sm"><?= $pkg['daily_profit'] ?> يومياً</div>
                <div class="pkg-price-sm">$<?= number_format($pkg['price']) ?></div>
                
                <form method="post" action="buy.php">
                    <input type="hidden" name="pid" value="<?= $pkg['id'] ?>">
                    <button type="submit" class="pkg-buy-btn-sm" <?= $can_buy ? '' : 'disabled' ?>>
                        <?= $can_buy ? 'شراء الآن' : 'رصيد غير كافٍ' ?>
                    </button>
                </form>
            </div>
        </div>

        <?php 
            endwhile; 
        else:
        ?>
            <div style="padding: 20px; color: #666; width: 100%;">لا توجد باقات</div>
        <?php endif; ?>
    </div>

    <nav class="bottom-nav">
        <a href="home.php" class="nav-item active">
            <i class="fas fa-home"></i>
            <span>البيت</span>
        </a>
        <a href="tasks.php" class="nav-item">
            <i class="fas fa-tasks"></i>
            <span>المهام</span>
        </a>
        <a href="referral.php" class="nav-item">
            <i class="fas fa-users"></i>
            <span>الأصدقاء</span>
        </a>
        <a href="packages.php" class="nav-item">
            <i class="fas fa-box-open"></i>
            <span>الباقات</span>
        </a>
        <a href="profile.php" class="nav-item">
            <i class="fas fa-user-circle"></i>
            <span>ملفي</span>
        </a>
    </nav>

</body>
</html>