<?php 
include 'db.php'; 
session_start();
if(!isset($_SESSION['user'])){ header("Location: login.php"); exit(); }
 $u = $_SESSION['user']; 

// تكوين الرابط الكامل (الدومين + رابط التسجيل + كود الدعوة)
 $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
 $domain = $_SERVER['HTTP_HOST'];
 $ref_link = $protocol . $domain . "/register.php?ref=" . $u['referral_code'];

// ملاحظة: يمكنك إضافة استعلام هنا لجلب عدد المدعوين وأرباح الدعوات من قاعدة البيانات
// مثال: $ref_stats = $conn->query("SELECT COUNT(*) as count, SUM(amount) as total FROM referrals WHERE referrer_id={$u['id']}");
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Chicken Charge - دعوة أصدقاء</title>
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #FFD700; 
            --secondary-color: #FF4500;
            --bg-dark: #121212;
            --card-bg: #1e1e1e;
            --text-muted: #aaa;
        }

        body {
            font-family: 'Tajawal', sans-serif;
            background-color: var(--bg-dark);
            color: white;
            margin: 0;
            padding-bottom: 80px; /* مساحة للشريط السفلي */
        }

        /* الشريط العلوي */
        .top-bar {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 15px 20px;
            background: var(--card-bg);
            border-bottom: 1px solid rgba(255, 215, 0, 0.1);
        }

        .top-bar .brand {
            font-weight: bold;
            font-size: 1.2rem;
            background: linear-gradient(45deg, var(--primary-color), var(--secondary-color));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        /* المحتوى الرئيسي */
        .container {
            padding: 20px;
        }

        .section-title {
            margin-bottom: 20px;
            font-size: 1.2rem;
            border-right: 4px solid var(--secondary-color);
            padding-right: 10px;
        }

        /* كرت رابط الدعوة */
        .ref-card {
            background: var(--card-bg);
            border-radius: 20px;
            padding: 25px;
            text-align: center;
            border: 1px solid rgba(255, 255, 255, 0.05);
            margin-bottom: 25px;
        }

        .ref-icon {
            font-size: 3rem;
            color: var(--primary-color);
            margin-bottom: 15px;
        }

        .ref-desc {
            color: var(--text-muted);
            margin-bottom: 20px;
            font-size: 0.9rem;
        }

        /* حقل الإدخال */
        .link-box {
            display: flex;
            gap: 10px;
            background: #121212;
            padding: 5px;
            border-radius: 12px;
            border: 1px solid rgba(255, 255, 255, 0.1);
        }

        .link-box input {
            flex: 1;
            background: transparent;
            border: none;
            color: #ccc;
            padding: 10px;
            font-family: 'Tajawal', sans-serif;
            font-size: 0.9rem;
            text-align: center;
            outline: none;
        }

        .copy-btn {
            background: var(--secondary-color);
            color: white;
            border: none;
            padding: 0 20px;
            border-radius: 8px;
            cursor: pointer;
            font-weight: bold;
            transition: 0.2s;
        }

        .copy-btn:active {
            transform: scale(0.95);
        }

        /* إحصائيات الدعوة */
        .stats-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 15px;
            margin-top: 20px;
        }

        .stat-card {
            background: var(--card-bg);
            padding: 20px;
            border-radius: 15px;
            text-align: center;
            border-bottom: 3px solid var(--primary-color);
        }

        .stat-card.secondary {
            border-bottom-color: var(--secondary-color);
        }

        .stat-val {
            font-size: 1.5rem;
            font-weight: bold;
            margin-bottom: 5px;
        }

        .stat-label {
            font-size: 0.8rem;
            color: var(--text-muted);
        }

        /* الشريط السفلي */
        .bottom-nav {
            position: fixed;
            bottom: 0;
            width: 100%;
            background: var(--card-bg);
            display: flex;
            justify-content: space-around;
            padding: 10px 0;
            border-top: 1px solid rgba(255, 215, 0, 0.1);
            z-index: 1000;
        }

        .nav-item {
            text-decoration: none;
            color: #888;
            display: flex;
            flex-direction: column;
            align-items: center;
            font-size: 0.7rem;
        }

        .nav-item.active {
            color: var(--primary-color);
        }

        .nav-item i {
            font-size: 1.3rem;
            margin-bottom: 4px;
        }
    </style>
</head>
<body>

    <!-- الشريط العلوي -->
    <div class="top-bar">
        <div class="brand">Chicken Charge</div>
        <div style="font-size: 0.8rem; color: #888;">
            <i class="fas fa-user"></i> <?= $u['username'] ?>
        </div>
    </div>

    <div class="container">
        <div class="section-title">دعوة أصدقاء</div>

        <div class="ref-card">
            <div class="ref-icon">
                <i class="fas fa-gift"></i>
            </div>
            <p class="ref-desc">شارك الرابط مع أصدقك واربح عمولات مجانية عند تسجيلهم!</p>
            
            <div class="link-box">
                <input type="text" id="refLink" value="<?= $ref_link ?>" readonly>
                <button class="copy-btn" onclick="copyLink()">نسخ</button>
            </div>
        </div>

        <!-- إحصائيات الدعوة -->
        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-val" style="color: var(--primary-color);">
                    <!-- هنا يمكنك وضع المتغير الذي يجلب عدد المدعوين -->
                    <?php echo isset($u['invites_count']) ? $u['invites_count'] : '0'; ?>
                </div>
                <div class="stat-label">عدد المدعوين</div>
            </div>
            
            <div class="stat-card secondary">
                <div class="stat-val" style="color: var(--secondary-color);">
                    <!-- هنا يمكنك وضع المتغير الذي يجلب أرباح الدعوة -->
                    <?php echo isset($u['ref_earnings']) ? '$'.number_format($u['ref_earnings'], 2) : '$0.00'; ?>
                </div>
                <div class="stat-label">أرباح الدعوات</div>
            </div>
        </div>
    </div>

    <!-- الشريط السفلي -->
    <nav class="bottom-nav">
        <a href="home.php" class="nav-item">
            <i class="fas fa-home"></i>
            <span>البيت</span>
        </a>
        <a href="tasks.php" class="nav-item">
            <i class="fas fa-tasks"></i>
            <span>المهام</span>
        </a>
        <!-- تفعيل زر الأصدقاء -->
        <a href="referral.php" class="nav-item active">
            <i class="fas fa-users"></i>
            <span>الأصدقاء</span>
        </a>
        <a href="packages.php" class="nav-item">
            <i class="fas fa-box-open"></i>
            <span>الباقات</span>
        </a>
        <a href="profile.php" class="nav-item">
            <i class="fas fa-user-circle"></i>
            <span>ملفي</span>
        </a>
    </nav>

    <!-- سكربت النسخ -->
    <script>
        function copyLink() {
            var copyText = document.getElementById("refLink");
            copyText.select();
            copyText.setSelectionRange(0, 99999); /* For mobile devices */
            navigator.clipboard.writeText(copyText.value).then(function() {
                // تغيير نص الزر مؤقتاً
                var btn = document.querySelector('.copy-btn');
                var originalText = btn.innerText;
                btn.innerText = "تم النسخ!";
                btn.style.background = "#00ff00"; // أخضر
                setTimeout(function() {
                    btn.innerText = originalText;
                    btn.style.background = "var(--secondary-color)";
                }, 2000);
            }, function(err) {
                alert('فشل النسخ، يرجى النسخ يدوياً');
            });
        }
    </script>

</body>
</html>