<?php 
include 'db.php'; 
session_start();
if(!isset($_SESSION['user'])){ header("Location: login.php"); exit(); }
 $u = $_SESSION['user']; 
 $uid = $u['id'];

if(isset($_POST['spin_action'])){
    if($u['spins'] > 0){
        $prizes = [0, 0.5, 1, 1.5, 2, 10, 50, 60, 199];
        
        // اختيار فائزة عشوائية
        $winner_index = array_rand($prizes);
        $prize_amount = $prizes[$winner_index];
        
        // تحديث قاعدة البيانات
        $conn->query("UPDATE users SET spins=spins-1, withdraw_balance=withdraw_balance+$prize_amount WHERE id=$uid");
        
        $_SESSION['user']['spins']--;
        $_SESSION['user']['withdraw_balance'] += $prize_amount;

        // إرجاع رقم الفهرسة (0-8) للمربع الفائز
        echo json_encode(['status' => 'success', 'prize' => $prize_amount, 'winner_index' => $winner_index]);
        exit();
    } else {
        echo json_encode(['status' => 'error', 'message' => 'لا توجد فرص متاحة']);
        exit();
    }
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Chicken Charge - سحب الجوائز</title>
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #FFD700; 
            --secondary-color: #FF4500;
            --bg-dark: #121212;
            --card-bg: #1e1e1e;
            --box-bg: #2a2a2a;
            --active-color: #00ff00; /* اللون الأخضر المضيء */
        }

        body {
            font-family: 'Tajawal', sans-serif;
            background-color: var(--bg-dark);
            color: white;
            margin: 0;
            padding-bottom: 80px;
            display: flex;
            flex-direction: column;
            align-items: center;
            min-height: 100vh;
        }

        .top-bar {
            width: 100%;
            max-width: 600px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 15px 20px;
            margin-bottom: 20px;
        }

        .back-btn { color: white; text-decoration: none; font-size: 1.2rem; }

        .chances-box {
            background: var(--card-bg);
            padding: 10px 25px;
            border-radius: 25px;
            font-size: 1rem;
            color: var(--primary-color);
            border: 2px solid var(--primary-color);
            margin-bottom: 30px;
        }

        /* --- تصميم الشبكة (3x3 Grid) --- */
        .grid-container {
            display: grid;
            grid-template-columns: repeat(3, 1fr); /* 3 أعمدة */
            gap: 10px;
            width: 90%;
            max-width: 320px;
            margin-bottom: 40px;
        }

        .grid-box {
            background: var(--box-bg);
            aspect-ratio: 1; /* مربع مربع */
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.2rem;
            font-weight: bold;
            color: #fff;
            border: 2px solid #333;
            transition: 0.2s;
            text-shadow: 1px 1px 2px black;
        }

        /* --- المربع المضيء (الأخضر) --- */
        .grid-box.active {
            background: var(--active-color);
            color: black;
            border-color: var(--active-color);
            box-shadow: 0 0 15px var(--active-color);
            transform: scale(1.05);
            z-index: 2;
            text-shadow: none;
        }

        /* زر الدوران */
        .spin-btn {
            padding: 18px 60px;
            border-radius: 30px;
            border: none;
            background: linear-gradient(45deg, var(--secondary-color), #ff6b6b);
            color: white;
            font-size: 1.3rem;
            font-weight: bold;
            font-family: 'Tajawal', sans-serif;
            cursor: pointer;
            box-shadow: 0 5px 25px rgba(255, 69, 0, 0.4);
            transition: 0.3s;
        }
        .spin-btn:active { transform: scale(0.95); }
        .spin-btn:disabled {
            background: #444;
            color: #888;
            cursor: not-allowed;
            box-shadow: none;
        }

        /* نافذة الفوز */
        .win-modal {
            position: fixed;
            top: 0; left: 0; width: 80%; height: 80%;
            background: rgba(0,0,0,0.9);
            display: none;
            justify-content: center;
            align-items: center;
            z-index: 2000;
        }
        .win-content {
            background: var(--card-bg);
            padding: 40px;
            border-radius: 25px;
            text-align: center;
            border: 3px solid var(--primary-color);
            min-width: 300px;
            animation: popIn 0.5s;
        }
        .win-amount {
            font-size: 3.5rem;
            color: var(--primary-color);
            font-weight: bold;
            margin: 15px 0;
        }
        @keyframes popIn {
            from { transform: scale(0.5); opacity: 0; }
            to { transform: scale(1); opacity: 1; }
        }
    </style>
</head>
<body>

    <div class="top-bar" style="justify-content: flex-end;">
        <a href="home.php" class="back-btn"><i class="fas fa-times"></i></a>
    </div>

    <div class="chances-box">
        الفرص المتاحة: <span id="spinsCount"><?= $u['spins'] ?></span>
    </div>

    <!-- شبكة المربعات -->
    <div class="grid-container" id="gridContainer">
        <?php 
            $prizes = [0, 0.5, 1, 1.5, 2, 10, 50, 60, 199];
            // إنشاء 9 مربعات
            for($i=0; $i<count($prizes); $i++):
        ?>
            <div class="grid-box" id="box-<?= $i ?>">
                <?= $prizes[$i] ?>$             </div>
        <?php endfor; ?>
    </div>

    <button id="spinBtn" class="spin-btn" onclick="startSpin()">
        <i class="fas fa-play"></i> ابدأ
    </button>

    <!-- نافذة الفوز -->
    <div class="win-modal" id="winModal">
        <div class="win-content">
            <i class="fas fa-trophy" style="font-size: 4rem; color: #FFD700;"></i>
            <h2>مبروك!</h2>
            <p>الرقم الفائز هو</p>
            <div class="win-amount" id="winAmount">0$</div>
            <button class="spin-btn" style="padding: 12px 40px; font-size: 1rem; margin-top:20px;" onclick="closeModal()">إغلاق</button>
        </div>
    </div>

    <script>
        const spinBtn = document.getElementById('spinBtn');
        const spinsCount = document.getElementById('spinsCount');
        const boxes = document.querySelectorAll('.grid-box');
        let isSpinning = false;
        let spinInterval;

        function startSpin() {
            if(isSpinning) return;

            let currentSpins = parseInt(spinsCount.innerText);
            if(currentSpins <= 0) {
                alert("لا توجد فرص متاحة!");
                return;
            }

            isSpinning = true;
            spinBtn.disabled = true;

            // إرسال طلب للسيرفر
            const formData = new FormData();
            formData.append('spin_action', 'true');

            fetch('spin.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if(data.status === 'success') {
                    spinsCount.innerText = currentSpins - 1;
                    
                    // بدء حركة المربع الأخضر
                    runSpinAnimation(data.winner_index, data.prize);
                } else {
                    alert(data.message);
                    isSpinning = false;
                    spinBtn.disabled = false;
                }
            })
            .catch(error => {
                console.error('Error:', error);
                isSpinning = false;
                spinBtn.disabled = false;
            });
        }

        function runSpinAnimation(winnerIndex, prizeAmount) {
            let currentIndex = 0;
            let speed = 100; // سرعة بدء سريعة
            let loops = 0;
            let maxLoops = 20; // عدد الدورات الكاملة قبل التوقف

            // إزالة أي تنشيط سابق
            boxes.forEach(box => box.classList.remove('active'));

            // دالة الحركة
            function step() {
                // إزالة التنشيط من المربع السابق
                let prevIndex = currentIndex === 0 ? 8 : currentIndex - 1;
                boxes[prevIndex].classList.remove('active');

                // تفعيل المربع الحالي
                boxes[currentIndex].classList.add('active');

                // الانتقال للمربع التالي
                currentIndex++;
                if(currentIndex > 8) {
                    currentIndex = 0;
                    loops++;
                }

                // التحقق من التوقف
                if(loops >= maxLoops && currentIndex === parseInt(winnerIndex)) {
                    clearInterval(spinInterval);
                    setTimeout(() => {
                        showWin(prizeAmount);
                    }, 500); // مهلة قصيرة للتوقف الكامل
                } else {
                    // زيادة السرعة (تقليل الرقم) أو التباطؤ (زيادة الرقم) بشكل تدريجي
                    if(loops > maxLoops - 5) {
                        speed += 50; // التباطؤ في اللفات الأخيرة
                    }
                    spinInterval = setTimeout(step, speed);
                }
            }

            step(); // بدء الحركة
        }

        function showWin(amount) {
            document.getElementById('winAmount').innerText = amount + "$";
            document.getElementById('winModal').style.display = 'flex';
            isSpinning = false;
            let currentSpins = parseInt(spinsCount.innerText);
            if(currentSpins > 0) spinBtn.disabled = false;
        }

        function closeModal() {
            document.getElementById('winModal').style.display = 'none';
            location.reload();
        }
    </script>

</body>
</html>

<!-- قسم زر الدعوة والشرح -->
<div style="margin-top: 40px; text-align: center; padding-top: 20px; border-top: 1px dashed #333;">
    
    <!-- نص الشرح -->
    <p style="color: #FFD700; font-size: 0.9rem; margin-bottom: 15px;">
        يمكنك الحصول على فرصة إضافية من دعوة أصدقاء قاموا بشراء باقة
    </p>

    <!-- زر دعوة الأصدقاء -->
    <a href="referral.php" style="
        display: inline-flex; 
        align-items: center; 
        gap: 8px; 
        background: #1e1e1e; 
        border: 2px solid #FFD700; 
        color: #FFD700; 
        padding: 12px 30px; 
        border-radius: 25px; 
        text-decoration: none; 
        font-weight: bold; 
        font-family: 'Tajawal', sans-serif;
        font-size: 1rem;
        box-shadow: 0 0 10px rgba(255, 215, 0, 0.1);
        transition: 0.3s;
    " onmouseover="this.style.background='#FFD700'; this.style.color='#000';" 
       onmouseout="this.style.background='#1e1e1e'; this.style.color='#FFD700';">
        <i class="fas fa-users"></i> دعوة أصدقاء
    </a>

</div>