<?php 
include 'db.php'; 
session_start();
if(!isset($_SESSION['user'])){ header("Location: login.php"); exit(); }
 $u = $_SESSION['user']; 
 $uid = $u['id'];

 $msg = "";

if(isset($_POST['w'])){
    $a = floatval($_POST['amount']);
    $ad = htmlspecialchars($_POST['address']);
    
    // التحقق من صحة البيانات
    if($a > 0 && !empty($ad)){
        // التحقق مما إذا كان الرصيد يكفي
        if($a <= $u['withdraw_balance']){
            $conn->query("INSERT INTO withdrawals(user_id,amount,address) VALUES($uid,$a,'$ad')");
            $msg = "<div class='success-box'><i class='fas fa-check-circle'></i> تم إرسال طلب السحب بنجاح!</div>";
        } else {
            $msg = "<div class='error-box'><i class='fas fa-exclamation-triangle'></i> رصيد السحب غير كافٍ!</div>";
        }
    } else {
        $msg = "<div class='error-box'><i class='fas fa-exclamation-circle'></i> يرجى إدخال المبلغ وعنوان المحفظة.</div>";
    }
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Chicken Charge - سحب</title>
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #FFD700; 
            --secondary-color: #FF4500;
            --bg-dark: #121212;
            --card-bg: #1e1e1e;
            --text-muted: #aaa;
        }

        body {
            font-family: 'Tajawal', sans-serif;
            background-color: var(--bg-dark);
            color: white;
            margin: 0;
            padding-bottom: 80px;
        }

        /* الشريط العلوي */
        .top-bar {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 15px 20px;
            background: var(--card-bg);
            border-bottom: 1px solid rgba(255, 215, 0, 0.1);
        }

        .top-bar .brand {
            font-weight: bold;
            font-size: 1.2rem;
            background: linear-gradient(45deg, var(--primary-color), var(--secondary-color));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .back-btn {
            color: white;
            text-decoration: none;
            font-size: 1.2rem;
        }

        /* المحتوى */
        .container {
            padding: 20px;
        }

        .section-title {
            margin-bottom: 20px;
            font-size: 1.2rem;
            border-right: 4px solid var(--secondary-color);
            padding-right: 10px;
        }

        /* كرت الرصيد */
        .balance-card {
            background: var(--card-bg);
            border-radius: 20px;
            padding: 25px;
            text-align: center;
            margin-bottom: 25px;
            border-bottom: 3px solid var(--secondary-color);
        }

        .balance-label {
            color: var(--text-muted);
            font-size: 0.9rem;
            margin-bottom: 10px;
        }

        .balance-amount {
            font-size: 2.5rem;
            font-weight: bold;
            color: var(--primary-color);
            text-shadow: 0 0 10px rgba(255, 215, 0, 0.2);
        }

        /* نموذج السحب */
        .withdraw-form {
            background: var(--card-bg);
            border-radius: 20px;
            padding: 20px;
        }

        .input-group {
            margin-bottom: 15px;
        }

        .input-label {
            display: block;
            margin-bottom: 8px;
            color: var(--text-muted);
            font-size: 0.9rem;
        }

        .input-field {
            width: 100%;
            background: #121212;
            border: 1px solid #333;
            padding: 12px 15px;
            border-radius: 12px;
            color: white;
            font-family: 'Tajawal', sans-serif;
            box-sizing: border-box;
            outline: none;
            font-size: 1rem;
        }

        .input-field:focus {
            border-color: var(--secondary-color);
        }

        .submit-btn {
            width: 100%;
            background: linear-gradient(45deg, var(--secondary-color), #ff6b6b);
            color: white;
            border: none;
            padding: 14px;
            border-radius: 12px;
            font-family: 'Tajawal', sans-serif;
            font-weight: bold;
            font-size: 1rem;
            cursor: pointer;
            box-shadow: 0 4px 15px rgba(255, 69, 0, 0.3);
            transition: 0.3s;
            margin-top: 10px;
        }

        .submit-btn:active {
            transform: scale(0.98);
        }

        /* رسائل التنبيه */
        .success-box {
            background: rgba(0, 255, 0, 0.1);
            color: #00ff00;
            padding: 10px;
            border-radius: 10px;
            margin-bottom: 20px;
            text-align: center;
            border: 1px solid rgba(0, 255, 0, 0.2);
        }

        .error-box {
            background: rgba(255, 0, 0, 0.1);
            color: #ff4d4d;
            padding: 10px;
            border-radius: 10px;
            margin-bottom: 20px;
            text-align: center;
            border: 1px solid rgba(255, 0, 0, 0.2);
        }

        /* الشريط السفلي */
        .bottom-nav {
            position: fixed;
            bottom: 0;
            width: 100%;
            background: var(--card-bg);
            display: flex;
            justify-content: space-around;
            padding: 10px 0;
            border-top: 1px solid rgba(255, 215, 0, 0.1);
            z-index: 1000;
        }

        .nav-item {
            text-decoration: none;
            color: #888;
            display: flex;
            flex-direction: column;
            align-items: center;
            font-size: 0.7rem;
        }

        .nav-item.active {
            color: var(--primary-color);
        }

        .nav-item i {
            font-size: 1.3rem;
            margin-bottom: 4px;
        }
    </style>
</head>
<body>

    <!-- الشريط العلوي -->
    <div class="top-bar">
        <a href="home.php" class="back-btn"><i class="fas fa-arrow-right"></i></a>
        <div class="brand">سحب الأرباح</div>
        <div style="width: 24px;"></div> <!-- عنصر وهمي للموازنة -->
    </div>

    <div class="container">
        
        <!-- عرض الرصيد القابل للسحب -->
        <div class="balance-card">
            <div class="balance-label">الرصيد المتاح للسحب</div>
            <div class="balance-amount">$<?= number_format($u['withdraw_balance'], 2) ?></div>
        </div>

        <div class="section-title">طلب سحب جديد</div>

        <!-- نموذج السحب -->
        <div class="withdraw-form">
            <?= $msg ?>

            <form method="post">
                <div class="input-group">
                    <label class="input-label">المبلغ (بالدولار)</label>
                    <input type="number" step="0.01" name="amount" class="input-field" placeholder="مثلاً: 10.00" required>
                </div>

                <div class="input-group">
                    <label class="input-label">عنوان المحفظة (USDT TRC20)</label>
                    <input type="text" name="address" class="input-field" placeholder="Txxxxxxxxxxxxxxxxxx..." required>
                </div>

                <button type="submit" name="w" class="submit-btn">
                    إرسال طلب السحب <i class="fas fa-wallet" style="margin-right: 5px;"></i>
                </button>
            </form>
        </div>

        <div style="text-align:center; margin-top:15px; color:#666; font-size:0.8rem;">
            * الحد الأدنى للسحب 5 دولارات<br>
            * يتم خصم المبلغ فوراً عند الموافقة
        </div>

    </div>

    

</body>
</html>